% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.VCF2MVP}
\alias{MVP.Data.VCF2MVP}
\title{MVP.Data.VCF2MVP: To transform vcf data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018}
\usage{
MVP.Data.VCF2MVP(
  vcf_file,
  out = "mvp",
  maxLine = 10000,
  type.geno = "char",
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{vcf_file}{Genotype in VCF format}

\item{out}{the name of output file}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{type.geno}{the type of genotype elements}

\item{threads}{number of thread for transforming}

\item{verbose}{whether to print the reminder}
}
\value{
number of individuals and markers.
Output files:
genotype.desc, genotype.bin: genotype file in bigmemory format
phenotype.phe: ordered phenotype file, same taxa order with genotype file
map.map: SNP information
}
\description{
Accept the | or / separated markers, any variant sites that are not 0 or 1 will be considered NA.
}
\examples{
\donttest{
vcfPath <- system.file("extdata", "01_vcf", "mvp.vcf", package = "rMVP")

MVP.Data.VCF2MVP(vcfPath, tempfile("outfile"), threads=1)
}

}
