% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCT.R
\name{bct}
\alias{bct}
\title{Boundary Convexity Tool}
\usage{
bct(sfDataObject, step, window, ridName = NULL, filename = "")
}
\arguments{
\item{sfDataObject}{An sf Object containing shape file data.}

\item{step}{A numeric describing the distance between measurements along an arc.}

\item{window}{A numeric describing the diameter of the window used to measure convexity.}

\item{ridName}{A character denoting the column name where the unique ID for each feature is stored in 
given sf object.}

\item{filename}{A character denoting the name of the file you wish to output convexity data to in tab delimited format. Must have the .txt extension.}
}
\value{
The output of this function is a \code{data.frame} that contains all measurements for each step and feature.
}
\description{
Calculates raw convexity, convexity index, and sinuosity of a given sf object and returns a data frame with all measurements for each step and feature. If provided, the data will also be output to a tab delimited file.
}
\details{
This function will reject any sf object with a geographic coordinate system, so consider projecting your features. Your sf object must be of either type LINESTRING, MULTILINESTRING, POLYGON, or MULTIPOLYGON. If a given POLYGON or MUTLIPOLYGON contains inner rings, they will be ignored. If a unique ID Column name is not provided, the function will generate a unique ID for each feature. The arguments \code{step} and \code{window} can be any non-negative numeric. The argument \code{ridName} MUST be a character indicating the name of the column in your sf object where the route id is stored.
}
\section{Reference}{

Albeke, S.E. et al. \emph{“Measuring boundary convexity at multiple spatial scales using a linear “moving window” analysis: an application to coastal river otter habitat selection.”} Landscape Ecology 25 (2010): 1575-1587. [linked phrase](https://link.springer.com/article/10.1007/s10980-010-9528-4)
}

\examples{
library(rLFT)
data("shpObject")
#store convexity output data in a variable 'outputTable'
outputTable <- bct(shpObject, step = 50, window = 100, ridName = "RID")

}
