% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{values_minimize}
\alias{values_minimize}
\title{Simplify a Kolada values table}
\usage{
values_minimize(values_df)
}
\arguments{
\item{values_df}{A Kolada value table, as created by
\code{\link{get_values}}.}
}
\value{
A Kolada values table
}
\description{
Simplify a Kolada values table, i.e as created by \code{\link{get_values}},
by removing columns that contain monotonous data, i.e. that contain only one
value for all observations.
}
\examples{
# Download values for a KPI for the year 2010
vals <- get_values(kpi = "N00002", period = 2010, simplify = TRUE) \%>\%
  dplyr::filter(municipality_type == "K")
# (Returns a table with 29 rows and 8 columns)

# Remove columns with no information to differentiate between rows
values_minimize(vals)
# (Returns a table with 29 rows and 4 columns)
}
