% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_01_to_event_table_wf_v2.r
\name{f_to_event_table_wf_v2}
\alias{f_to_event_table_wf_v2}
\title{ata transformation: Wide format -> Event format required for the model (internal use)}
\usage{
f_to_event_table_wf_v2(id, start, stop, outcome, data, times, doses, covars)
}
\arguments{
\item{id}{name of variable containing the names of subjects}

\item{start}{names of the variable containing the start time}

\item{stop}{names of the variable containing the stop time}

\item{outcome}{name of the variable containing the outcome}

\item{data}{input data set - wide format data set}

\item{times}{sub data set of times relatives to doses}

\item{doses}{sub data set of grouped doses}

\item{covars}{sub data set of the covars that will be involved in the model}
}
\value{
The data set with the event-row format, including the event of exit of the cohort
}
\description{
This function organize an input data set wf (wide format) to ef(event format), same as f_to_event_table_wf_all but with the start, stop and outcome from the formula
}
\examples{
\donttest{ f_to_event_table_wf_v2(id='patientids',start='entry_age',stop='exit_age',
                              outcome='leukaemia',data,times=data[,11:30],doses=data[,31:50],
                              covars=data[,c('sex','country','birthcohort')])}
}
