% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ehr_simulation.R
\name{simulate_ehr_events}
\alias{simulate_ehr_events}
\title{Generate simulated events tables}
\usage{
simulate_ehr_events(ehr_def, consultation, event_type = c("clinical",
  "referral", "therapy"), cores = 1, therapy_lookup = NULL)
}
\arguments{
\item{ehr_def}{an object of class \code{link{EHR_definition}}}

\item{consultation}{a dataframe of simulated patient consultations}

\item{event_type}{Type of events to be generated}

\item{cores}{number of processor cores to use in generating the data}

\item{therapy_lookup}{lookup table for drug therapy events e.g. \code{link{product}}}
}
\value{
dataframe
}
\description{
This function can generate events for clinical, referral and therapy tables.  These are based on
the consultation tables generated by \code{\link{simulate_ehr_consultations}}.
}
\details{
This function is relatively basic - for clinical and referral tables, it generates 
events according to the comorbidities defined in the \code{ehr_def}, with the mean number of events 
for each consultation being defined in the ehr_def for that event_type.
For therapy events, the function simply samples the therapy_lookup table, with the mean number 
of events for each consultation being defined in the ehr_def for therapy.  Therefore, at the 
moment, the therapies bear no relationship to the conditions the patient has and are only for 
the purposes of explaining the functioning of the package.
The random sampling is based on a poisson distribution
}

