% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.als.R
\name{depthVsSample}
\alias{depthVsSample}
\title{Simulate median allele ratios for varying number of samples and depth values}
\usage{
depthVsSample(
  cov.len = 100,
  sam.len = 100,
  nsims = 1000,
  plot = TRUE,
  col = c("#1C86EE", "#00BFFF", "#DAA520", "#FF0000")
)
}
\arguments{
\item{cov.len}{max value of depth of coverage to be simulated}

\item{sam.len}{maximum no. of samples to be simulated}

\item{nsims}{numerical. no. of simulations to be done for each combination of samples and depth
depth and no. samples ranges}

\item{plot}{logical. Whether to plot the output (a plot of no. samples
vs median depth of coverage colored by median allele ratios)}

\item{col}{character. Two colors to add to the gradient}
}
\value{
A matrix of median allele ratios where rows are the number of
samples and columns are depth of coverage values
}
\description{
This function will simulate the expected median allele ratios under HWE
for given ranges of no. of samples and depth coverage values.
This is useful if you need to find the cutoff values of allele ratios for
different no. of samples and depth of coverage values in your data set.
}
\examples{
\dontrun{depthVsSample(cov.len=100,sam.len=100)}

}
\author{
Pascal Milesi, Piyal Karunarathne
}
