% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_coefficient.R
\name{generate_coefficient}
\alias{generate_coefficient}
\title{Generate updated validity coefficient using Fisher Z Transformation}
\usage{
generate_coefficient(n, lower_bound, upper_bound, interval = 0.95, seed = 42)
}
\arguments{
\item{n}{the samples for the normal distribution}

\item{lower_bound}{numeric the lower boundary of the validity coefficient}

\item{upper_bound}{numeric the upper boudnary of the validity coefficient}

\item{interval}{numeric the confidence interval to use (default 0.95)}

\item{seed}{numeric the random seed to use}
}
\value{
Validity coefficient
}
\description{
Using the Fisher Z Transformation, generate new
validity coefficients based on proposed upper and lower boundaries.
This new validity coefficient is based on transformed upper and lower
boundaries as well as a fitted normal distribution to the se new
proposed upper and lower boundaries.
}
\examples{
n <- 1000
coef_upper <- 0.9
coef_lower <- 0.3
ci <- 0.95
generate_coefficient(n, coef_lower, coef_upper, ci)
}
