% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_output.R
\name{SS_output}
\alias{SS_output}
\title{A function to create a list object for the output from Stock Synthesis}
\usage{
SS_output(dir = "C:/myfiles/mymodels/myrun/", dir.mcmc = NULL,
  repfile = "Report.sso", compfile = "CompReport.sso",
  covarfile = "covar.sso", forefile = "Forecast-report.sso",
  wtfile = "wtatage.ss_new", warnfile = "warning.sso", ncols = 200,
  forecast = TRUE, warn = TRUE, covar = TRUE, readwt = TRUE,
  checkcor = TRUE, cormax = 0.95, cormin = 0.01, printhighcor = 10,
  printlowcor = 10, verbose = TRUE, printstats = TRUE,
  hidewarn = FALSE, NoCompOK = FALSE, aalmaxbinrange = 4)
}
\arguments{
\item{dir}{Directory containing the Stock Synthesis model output.
Forwardslashes or double backslashes and quotes are necessary.
This can also either be an absolute path or relative to the working
directory.}

\item{dir.mcmc}{Optional directory containing MCMC output. This can either be
relative to \code{dir}, such that \code{file.path(dir, dir.mcmc)}
will end up in the right place, or an absolute path.}

\item{repfile}{Name of the big report file (could be renamed by user).}

\item{compfile}{Name of the composition report file.}

\item{covarfile}{Name of the covariance output file.}

\item{forefile}{Name of the forecast file.}

\item{wtfile}{Name of the file containing weight at age data.}

\item{warnfile}{Name of the file containing warnings.}

\item{ncols}{The maximum number of columns in files being read in.  If this
value is too big the function runs more slowly, too small and errors will
occur.  A warning will be output to the R command line if the value is too
small. It should be bigger than the maximum age + 10 and the number of years
+ 10.}

\item{forecast}{Read the forecast-report file?}

\item{warn}{Read the Warning.sso file?}

\item{covar}{Read covar.sso to get variance information and identify bad
correlations?}

\item{readwt}{Read the weight-at-age file?}

\item{checkcor}{Check for bad correlations?}

\item{cormax}{The specified threshold for defining high correlations.  A
quantity with any correlation above this value is identified.}

\item{cormin}{The specified threshold for defining low correlations.  Only
quantities with all correlations below this value are identified (to find
variables that appear too independent from the model results).}

\item{printhighcor}{The maximum number of high correlations to print to the
R GUI.}

\item{printlowcor}{The maximum number of low correlations to print to the R
GUI.}

\item{verbose}{Return updates of function progress to the R GUI?}

\item{printstats}{Print summary statistics about the output to the R GUI?}

\item{hidewarn}{Hides some warnings output from the R GUI.}

\item{NoCompOK}{Allow the function to work without a CompReport file.}

\item{aalmaxbinrange}{The largest length bin range allowed for composition
data to be considered as conditional age-at-length data.}
}
\value{
Many values are returned. Complete list would be quite long, but
should probably be created at some point in the future.
}
\description{
Reads the Report.sso and (optionally) the covar.sso, CompReport.sso and
other files files produced by Stock Synthesis and formats the important
content of these files into a list in the R workspace. A few statistics
unavailable elsewhere are taken from the .par and .cor files. Summary
information and statistics can be returned to the R console or just
contained within the list produced by this function.
}
\examples{

  \dontrun{
    # read model output
    myreplist <- SS_output(dir='c:/SS/Simple/')
    # make a bunch of plots
    SS_plots(myreplist)

    # read model output and also read MCMC results (if run), which in
    # this case would be stored in c:/SS/Simple/mcmc/
    myreplist <- SS_output(dir='c:/SS/Simple/', dir.mcmc="mcmc")
  }

}
\seealso{
\code{\link{SS_plots}}
}
\author{
Ian Stewart, Ian Taylor
}
