% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotSpawnrecruit.R
\name{SSplotSpawnrecruit}
\alias{SSplotSpawnrecruit}
\title{Plot spawner-recruit curve.}
\usage{
SSplotSpawnrecruit(replist, subplot = 1:2, add = FALSE, plot = TRUE,
  print = FALSE, xlim = NULL, ylim = NULL,
  xlab = "Spawning biomass (mt)", ylab = "Recruitment (1,000s)",
  bioscale = "default", plotdir = "default", pwidth = 6.5, pheight = 5,
  punits = "in", res = 300, ptsize = 10, cex.main = 1, verbose = TRUE,
  colvec = c("blue", "green3", "black", "red"), legend = TRUE,
  legendloc = "topleft", minyr = "default", textmindev = 0.5,
  virg = TRUE, init = TRUE, forecast = FALSE)
}
\arguments{
\item{replist}{list created by \code{SS_output}}

\item{subplot}{vector of which subplots to show.  1=plot without labels,
2=plot with year labels.}

\item{add}{add to existing plot?}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{xlim}{optional control of x range}

\item{ylim}{optional control of y range}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{bioscale}{multiplier on spawning biomass, set to 0.5 for single-sex
models}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{pwidth}{width of plot}

\item{pheight}{height of plot}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{point size for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{verbose}{report progress to R GUI?}

\item{colvec}{vector of length 4 with colors for 3 lines and 1 set of points}

\item{legend}{add a legend to the figure?}

\item{legendloc}{location of legend. See ?legend for more info}

\item{minyr}{minimum year of recruitment deviation to show in plot}

\item{textmindev}{minimum recruitment deviation for label to be added so
only extreme devs are labeled (labels are added to first and last years as
well).  Default=0.7.}

\item{virg}{add point for equilibrium conditions (x=B0,y=R0)}

\item{init}{add point for initial conditions (x=B1,y=R1), only appears
if this point differs from virgin values}

\item{forecast}{include forecast years in the curve?}
}
\description{
Plot spawner-recruit curve based on output from Stock Synthesis model.
}
\author{
Ian Stewart, Ian Taylor
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\keyword{hplot}

