% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_nrow.R
\name{rtf_nrow}
\alias{rtf_nrow}
\title{Add Number of Row Attributes for a Table}
\usage{
rtf_nrow(tbl)
}
\arguments{
\item{tbl}{A data frame}
}
\value{
a data frame with number of row attributes
}
\description{
Add number of row attributes for a table
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame.
   \item Return to a data frame with number of row attributes.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr) #required for running example
tbl <- iris[c(1:4, 50:54),] \%>\%
  rtf_title(title = "Iris example") \%>\%
  rtf_body()
r2rtf:::rtf_nrow(tbl)

}
