% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.payoffs.R
\name{summary.payoffs}
\alias{summary.payoffs}
\title{Summarize Payoffs}
\usage{
\method{summary}{payoffs}(object, ...)
}
\arguments{
\item{object}{A payoffs object.}

\item{...}{Additional arguments (not used).}
}
\value{
A tibble summarizing the estimated payoffs.
}
\description{
This function summarizes the payoffs object by classification.
}
\examples{
\dontrun{
library(dplyr)
library(earth)
library(baguette)
library(rules)
library(kknn)
library(viralmodels)
# Load required data
data(vl_3)
data(cd_3)

# Create interaction object and classification
interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)

# Prepare predictions
traindata <- interaction_obj[c(2, 5)] |> as_tibble()
target <- "vlogs_diff"
predictions_df <- viralpreds(target, 2, 1, 2, 123, traindata)

# Estimate payoffs
payoffs_results <- estimate_payoffs(class_obj, predictions_df)
summary(payoffs_results)
}
}
