% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pure_qubit1.R
\name{pure_qubit1}
\alias{pure_qubit1}
\title{Create a normalized pure quantum state for a 1-qubit system.}
\usage{
pure_qubit1(theta, phi, spherical = FALSE)
}
\arguments{
\item{theta}{The parameter theta in radians.}

\item{phi}{The parameter phi in radians.}

\item{spherical}{Whether to return coordinates in spherical form (default is FALSE).}
}
\value{
A qstate object representing the normalized pure quantum state for a 1-qubit system.
}
\description{
Create a normalized pure quantum state for a 1-qubit system.
}
\examples{
# Quantum simulator
library(qsimulatR)
# Define the parameters
theta <- pi/4
phi <- pi/6
# Create the quantum state
psi_qubit1 <- pure_qubit1(theta, phi)
psi_qubit1
}
