% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logistic_fun.R
\name{logistic_fun}
\alias{logistic_fun}
\title{Logistic function}
\usage{
logistic_fun(x, p)
}
\arguments{
\item{x}{Vector of values of the explanatory variable.}

\item{p}{Vector of parameters \eqn{p = c(\alpha, \beta)}.}
}
\value{
Probability at each \code{x}.
}
\description{
Logistic function of the form \eqn{ (1 + exp(-\beta * (x - \alpha)))^(-1) }
}
\examples{
xseq <- seq(0, 4, .01)
yseq <- logistic_fun(xseq, c(2, 4))
curve <- data.frame(x = xseq, y = yseq)
ggplot(curve, aes(x = x, y = y)) + geom_line()
}
\seealso{
\code{\link{inv_logistic_fun}}
}

