% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{is.lognormal}
\alias{is.lognormal}
\alias{is.normal}
\alias{is.uniform}
\alias{is.poisson}
\alias{is.gamma}
\alias{is.logistic}
\alias{is.weibull}
\alias{is.cauchy}
\alias{setDisAlpha}
\alias{unsetDisAlpha}
\title{Check if a data fits the distribution}
\usage{
is.lognormal(values, alpha = 0.05, method = 1)

is.normal(values, alpha = 0.05, method = 1)

is.uniform(values, alpha = 0.05)

is.poisson(values, alpha = 0.05)

is.gamma(values, alpha = 0.05)

is.logistic(values, alpha = 0.05)

is.weibull(values, alpha = 0.05)

is.cauchy(values, alpha = 0.05)

setDisAlpha(alpha = 0.05)

unsetDisAlpha()
}
\arguments{
\item{values}{vector of values}

\item{alpha}{significance level to test p-value against}

\item{method}{method for calculation, where 1 = Shapiro-Wilk test and 2 = Kolmogorov-Smirnov test}
}
\value{
boolean value if lognormal distributed

boolean value if normal distributed

boolean value if uniform distributed

boolean value if poisson distributed

boolean value if gamma distributed

boolean value if logistic distributed

boolean value if logistic distributed

boolean value if cauchy distributed

setDisAlpha sets global significance level for testing of distribution

unsetDisAlpha removes global significance level for testing of distribution
}
\description{
Check whether a vector of data contains values that fit a distribution
}
\details{
This function takes a numeric vector as its input. This vector contains the dataset that will be analyzed.
\cr\cr
\strong{For Normal and LogNormal:}\cr\cr
- Method 1: we perform the Shapiro-Wilk test on the (log-transformed) data to test for normality.
The null hypothesis of the Shapiro-Wilk test is that the data are normally distributed.
If the p-value is greater than the chosen significance level (typically 0.05),
we fail to reject the null hypothesis, indicating that the data may follow a log-normal distribution.\cr\cr
- Method 2: we perform the Kolmogorov-Smirnov test on the log-transformed data, comparing it to a normal distribution with the same mean and standard deviation. Again, if the p-value is greater than the chosen significance level, it suggests that the data may follow a log-normal distribution.
These tests provide a statistical assessment of whether your data follows a log-normal distribution.
}
\examples{
# Set global alpha for testing significance
setDisAlpha(alpha = 0.05)

# Prepare all data to test
# Set the seed for reproducibility
set.seed(13200323)
lognormal_data <- stats::rlnorm(n = 4000, meanlog = 1, sdlog = 1) #lognormal data
normal_data <- stats::rnorm(n = 4000, mean = 10, sd = 3) #normal data
uniform_data <- stats::runif(4000,min=0,max=10) #uniform data
poisson_data <- stats::rpois(4000, lambda = 5) #poisson data
gamma_data <- stats::rgamma(4000,shape = 5, rate = 2) #gamma data
logis_data <- stats::rlogis(4000, location = 4, scale = 2)#logistic values
weibull_data <- stats::rweibull(4000, shape = 4, scale = 2) #weibull data
cauchy_data <- stats::rcauchy(4000, location = 8, scale = 5) #cauchy data

# EXAMPLE FOR is.lognormal

# Test if the data is lognormal
is.lognormal(lognormal_data)
is.lognormal(normal_data)
is.lognormal(uniform_data)
is.lognormal(poisson_data)
is.lognormal(gamma_data)
is.lognormal(logis_data)
is.lognormal(weibull_data)
is.lognormal(cauchy_data)
is.lognormal(1:4000)

# EXAMPLE FOR is.normal

# Test if the data fits a normal distribution
is.normal(lognormal_data)
is.normal(normal_data)
is.normal(uniform_data)
is.normal(poisson_data)
is.normal(gamma_data)
is.normal(logis_data)
is.normal(weibull_data)
is.normal(cauchy_data)
is.normal(1:4000)

\dontrun{
# EXAMPLES for is.uniform

# Test if the data fits a uniform distribution
is.uniform(lognormal_data)
is.uniform(normal_data)
is.uniform(uniform_data)
is.uniform(poisson_data)
is.uniform(gamma_data)
is.uniform(logis_data)
is.uniform(weibull_data)
is.uniform(cauchy_data)
is.uniform(1:4000)
}
\dontrun{
# EXAMPLE for is.poisson

# Test if the data fits a poisson distribution
is.poisson(lognormal_data)
is.poisson(normal_data)
is.poisson(uniform_data)
is.poisson(poisson_data)
is.poisson(gamma_data)
is.poisson(logis_data)
is.poisson(weibull_data)
is.poisson(cauchy_data)
is.poisson(1:4000)
}
\dontrun{
# EXAMPLE for is.gamma

# Test if the data fits a gamma distribution
is.gamma(lognormal_data)
is.gamma(normal_data)
is.gamma(uniform_data)
is.gamma(poisson_data)
is.gamma(gamma_data)
is.gamma(logis_data)
is.gamma(weibull_data)
is.gamma(cauchy_data)
is.gamma(1:4000)
}
\dontrun{
# EXAMPLE for is.logistic

# Test if the data fits a logistic distribution
is.logistic(lognormal_data)
is.logistic(normal_data)
is.logistic(uniform_data)
is.logistic(poisson_data)
is.logistic(gamma_data)
is.logistic(logis_data)
is.logistic(weibull_data)
is.logistic(cauchy_data)
is.logistic(1:4000)
}
\dontrun{
# Test if the data fits a weibull distribution
is.weibull(lognormal_data)
is.weibull(normal_data)
is.weibull(uniform_data)
is.weibull(poisson_data)
is.weibull(gamma_data)
is.weibull(logis_data)
is.weibull(weibull_data)
is.weibull(cauchy_data)
is.weibull(1:4000)
}
\dontrun{
# EXAMPLES for is.cauchy

# Test if the data fits a cauchy distribution
is.cauchy(lognormal_data)
is.cauchy(normal_data)
is.cauchy(uniform_data)
is.cauchy(poisson_data)
is.cauchy(gamma_data)
is.cauchy(logis_data)
is.cauchy(weibull_data)
is.cauchy(cauchy_data)
is.cauchy(1:4000)
}
\dontrun{
# set global distribution alpha

# default setting
setDisAlpha()

# set to 0.001
setDisAlpha(alpha = 0.01)
}
\dontrun{
# unset global distribution alpha

unsetDisAlpha()
}
}
