% File man/NewInput.MM1KK.Rd
\name{NewInput.MM1KK}
\alias{NewInput.MM1KK}
\title{Define the inputs of a new M/M/1/K/K queueing model}
\description{
  Define the inputs of a new M/M/1/K/K queueing model
}

\usage{
  \method{NewInput}{MM1KK}(lambda=0, mu=0, k=1)
}
\arguments{
  \item{lambda}{arrival rate}
  \item{mu}{server service rate}
  \item{k}{system capacity}
}

\details{Define the inputs of a new M/M/1/K/K queueing model}

\references{
  [Sixto2004] Sixto Rios Insua, Alfonso Mateos Caballero, M Concepcion Bielza Lozoya, Antonio Jimenez Martin (2004).\cr
\emph{Investigacion Operativa. Modelos deterministicos y estocasticos}.\cr
Editorial Centro de Estudios Ramon Areces.
}

\seealso{
  \code{\link{CheckInput.i_MM1KK}}
}

\examples{
## See example 10.13 in reference [Sixto2004] for more details.
## create input parameters
i_mm1kk <- NewInput.MM1KK(lambda=0.25, mu=4, k=2)

}
\keyword{M/M/1/K/K}
