% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{iccs_11}
\alias{iccs_11}
\title{Intraclass Correlation for Multiple Variables for Multilevel Analysis:
ICC(1,1)}
\usage{
iccs_11(data, vrb.nm, grp.nm, how = "lme", REML = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{grp.nm}{character vector of length 1 of a colname from \code{data}
specifying the grouping column.}

\item{how}{character vector of length 1 specifying how the ICC(1,1) should be
calculated. There are four options: 1) "lme" uses a linear mixed effects
model with the function \code{\link[nlme]{lme}} from the package
\code{nlme}, 2) "lmer" uses a linear mixed effects modeling with the
function \code{\link[lme4]{lmer}} from the package \code{lme4}, 3) "aov"
uses a one-way analysis of variance with the function
\code{\link[stats]{aov}}, and 4) "raw" uses the observed variances, which
provides a biased estimate of the ICC(1,1) and is not recommended (It is
only included for teaching purposes).}

\item{REML}{logical vector of length 1 specifying whether restricted maximum
likelihood estimation (TRUE) should be used rather than traditional maximum
likelihood (FALSE). This is only applicable to linear mixed effects models
when \code{how} is "lme" or "lmer".}
}
\value{
double vector containing ICC(1, 1) of the \code{vrb.nm} columns in
  \code{data} with names of the return object equal to \code{vrb.nm}.
}
\description{
\code{iccs_11} computes the intraclass correlation (ICC) for multiple
variables based on a single rater with a single dimension, aka ICC(1,1).
Traditionally, this is the type of ICC used for multilevel analysis where the
value is interpreted as the proportion of variance accounted for by group
membership. In other words, ICC(1,1) = the proportion of between-group
variance; 1 - ICC(1,1) = the proportion of within-group variance.
}
\examples{

tmp_nm <- c("outcome","case","session","trt_time")
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp_nm]
stats_by <- psych::statsBy(dat,
   group = "case") # requires you to include "case" column in dat
iccs_11(data = dat, vrb.nm = c("outcome","session","trt_time"), grp.nm = "case")

}
\seealso{
\code{icc_11} # ICC(1,1) for a single variable,
   \code{\link{icc_all_by}} # all six types of ICCs by group,
   \code{\link[nlme]{lme}} # how = "lme" function,
   \code{\link[lme4]{lmer}} # how = "lmer" function,
   \code{\link[stats]{aov}} # how = "aov" function,
}
