% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{agg_dfm}
\alias{agg_dfm}
\title{Data Information by Group}
\usage{
agg_dfm(
  data,
  vrb.nm,
  grp.nm,
  rep = FALSE,
  rtn.grp = !rep,
  sep = ".",
  rtn.result.nm = "result",
  fun,
  ...
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
set of variables to evaluate \code{fun} on.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{rep}{logical vector of length 1 specifying whether the result of
\code{fun} should be repeated for every instance of the group in
\code{data[vrb.nm]} (TRUE) or only once for each group (FALSE).}

\item{rtn.grp}{logical vector of length 1 specifying whether the group
columns (i.e., \code{data[grp.nm]}) should be included in the return object
as columns. The default is the opposite of \code{rep} as traditionally it
is most important to return the group columns when \code{rep} = FALSE.}

\item{sep}{character vector of length 1 specifying the string to paste the
group values together with when there are multiple grouping variables
(i.e., \code{length(grp.nm) > 1}). Only used if \code{rep} = FALSE and
\code{rtn.grp} = FALSE.}

\item{rtn.result.nm}{character vector of length 1 specifying the name for the
column of results in the return object. Only used if \code{rtn.grp} = TRUE.}

\item{fun}{function to evaluate each grouping of \code{data[vrb.nm]} by. This
function must return an atomic vector of length 1. If not, then consider
using \code{by2} or \code{plyr::dlply}.}

\item{...}{additional named arguments to \code{fun}.}
}
\value{
result of \code{fun} applied to each grouping of
  \code{data[vrb.nm]}. The structure of the return object depends on the
  arguments \code{rep} and \code{rtn.grp}.

\describe{
  \item{If rep = TRUE and rtn.grp = TRUE:}{then the return
  object is a data.frame with nrow = \code{nrow(data)} where the first
  columns are \code{data[grp.nm]} and the last column is the result of
  \code{fun} with colname = \code{rtn.result.nm}.}

  \item{If rep = TRUE and rtn.grp = FALSE:}{then the return
  object is an atomic vector with length = \code{nrow(data)} where the values
  are the result of \code{fun} and the names = \code{row.names(data)}.}

  \item{If rep = FALSE and rtn.grp = TRUE:}{then the return
  object is a data.frame with nrow =
  \code{length(levels(interaction(data[grp.nm])))} where the first columns
  are the unique group combinations in \code{data[grp.nm]} and the last
  column is the result of \code{fun} with colname = \code{rtn.result.nm}.}

  \item{If rep = FALSE and rtn.grp = FALSE:}{then the return
  object is an atomic vector with length
  \code{length(levels(interaction(data[grp.nm])))} where the values are the
  result of \code{fun} and the names are each group value pasted together by
  \code{sep} if there are multiple grouping variables (i.e.,
  \code{length(grp.nm)} > 2).}
 }
}
\description{
\code{agg_dfm} evaluates a function on a set of variables in a data.frame
separately for each group and combines the results back together. The
\code{rep} and \code{rtn.grp} arguments determine exactly how the results are
combined together. If \code{rep} = TRUE, then the result of \code{fun} is
repeated for every row of the group in \code{data[grp.nm]}; If \code{rep} =
FALSE, then the result of \code{fun} for each unique combination of
\code{data[grp.nm]} is returned once. If \code{rtn.grp} = TRUE, then the
results are returned in a data.frame where the first columns are the groups
from \code{data[grp.nm]}; If \code{rtn.grp} = FALSE, then the results are
returned in an atomic vector. Note, \code{agg_dfm} evaluates \code{fun} on
all the variables in \code{data[vrb.nm]} as a whole, If instead, you want to
evaluate \code{fun} separately for variable \code{vrb.nm} in \code{data},
then use \code{Agg}.
}
\details{
If \code{rep} = TRUE, then \code{agg_dfm} calls \code{ave_dfm}; if \code{rep}
= FALSE, then \code{agg_dfm} calls \code{by}. When \code{rep} = FALSE and
\code{rtn.grp} = TRUE, \code{agg_dfm} is very similar to \code{plyr::ddply};
when \code{rep} = FALSE and \code{rtn.grp} = FALSE, then \code{agg_dfm} is
very similar to \code{plyr::daply}.
}
\examples{

### one grouping variable

## by in base R
by(data = airquality[c("Ozone","Solar.R")], INDICES = airquality["Month"],
   simplify = FALSE, FUN = function(dat) cor(dat, use = "complete")[1,2])

## rep = TRUE

# rtn.group = TRUE
agg_dfm(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rep = TRUE, rtn.grp = TRUE, fun = function(dat) cor(dat, use = "complete")[1,2])

# rtn.group = FALSE
agg_dfm(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rep = TRUE, rtn.grp = FALSE, fun = function(dat) cor(dat, use = "complete")[1,2])

## rep = FALSE

# rtn.group = TRUE
agg_dfm(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rep = FALSE, rtn.grp = TRUE, fun = function(dat) cor(dat, use = "complete")[1,2])
suppressWarnings(plyr::ddply(.data = airquality[c("Ozone","Solar.R","Month")],
   .variables = "Month", .fun = function(dat) cor(dat, use = "complete")[1,2]))

# rtn.group = FALSE
agg_dfm(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rep = FALSE, rtn.grp = FALSE, fun = function(dat) cor(dat, use = "complete")[1,2])
suppressWarnings(plyr::daply(.data = airquality[c("Ozone","Solar.R","Month")],
   .variables = "Month", .fun = function(dat) cor(dat, use = "complete")[1,2]))

### two grouping variables

## by in base R
by(data = mtcars[c("mpg","cyl","disp")], INDICES = mtcars[c("vs","am")],
   FUN = nrow, simplify = FALSE) # with multiple group columns

## rep = TRUE

# rtn.grp = TRUE
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = TRUE, rtn.grp = TRUE, fun = nrow)

# rtn.grp = FALSE
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = TRUE, rtn.grp = FALSE, fun = nrow)

## rep = FALSE

# rtn.grp = TRUE
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, rtn.grp = TRUE, fun = nrow)
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, rtn.grp = TRUE, rtn.result.nm = "value", fun = nrow)

# rtn.grp = FALSE
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, rtn.grp = FALSE, fun = nrow)
agg_dfm(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, rtn.grp = FALSE, sep = "_", fun = nrow)

}
\seealso{
\code{\link{agg}}
   \code{\link{aggs}}
   \code{\link{by2}}
   \code{\link[plyr]{ddply}}
   \code{\link[plyr]{daply}}
}
