% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_wordscores.R
\name{textmodel_wordscores}
\alias{textmodel_wordscores}
\title{Wordscores text model}
\usage{
textmodel_wordscores(x, y, scale = c("linear", "logit"), smooth = 0)
}
\arguments{
\item{x}{the \link{dfm} on which the model will be trained}

\item{y}{vector of training scores associated with each document 
in \code{x}}

\item{scale}{scale on which to score the words; \code{"linear"} for classic 
LBG linear posterior weighted word class differences, or \code{"logit"}
for log posterior differences}

\item{smooth}{a smoothing parameter for word counts; defaults to zero for the
to match the LBG (2003) method.}
}
\description{
\code{textmodel_wordscores} implements Laver, Benoit and Garry's (2003) 
wordscores method for scaling of a single dimension.
}
\details{
Fitting a \code{textmodel_wordscores} results in an object of class 
  \code{textmodel_wordscores_fitted} containing the following slots:
}
\section{Slots}{

\describe{
\item{\code{scale}}{\code{linear} or \code{logit}, according to the value of 
\code{scale}}

\item{\code{Sw}}{the scores computed for each word in the training set}

\item{\code{x}}{the dfm on which the wordscores model was called}

\item{\code{y}}{the reference scores}

\item{\code{call}}{the function call that fitted the model}

\item{\code{method}}{takes a value of \code{wordscores} for this model}
}}

\section{Predict Methods}{
 A \code{predict} method is also available for a 
  fitted wordscores object, see 
  \code{\link{predict.textmodel_wordscores_fitted}}.
}

\examples{
(ws <- textmodel_wordscores(data_dfm_lbgexample, c(seq(-1.5, 1.5, .75), NA)))

predict(ws)
predict(ws, rescaling = "mv")
predict(ws, rescaling = "lbg")
}
\references{
Laver, Michael, Kenneth R Benoit, and John Garry. 2003. 
  "\href{http://www.kenbenoit.net/pdfs/WORDSCORESAPSR.pdf}{Extracting Policy Positions From Political Texts Using Words as Data.}" 
  \emph{American Political Science Review} 97(02): 311-31
  
  Beauchamp, N. 2012. "Using Text to Scale Legislatures with Uninformative 
  Voting." New York University Mimeo.
  
  Martin, L W, and G Vanberg. 2007. "A Robust Transformation Procedure for 
  Interpreting Political Text." \emph{Political Analysis} 16(1): 93-100.
}
\seealso{
\code{\link{predict.textmodel_wordscores_fitted}}
}
\author{
Kenneth Benoit
}
