% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_dist.R, R/textstat_simil.R
\name{textstat_dist}
\alias{textstat_dist}
\alias{textstat_simil}
\title{Similarity and distance computation between documents or features}
\usage{
textstat_dist(x, selection = NULL, n = NULL, margin = c("documents",
  "features"), method = "euclidean", upper = FALSE, diag = FALSE, p = 2)

textstat_simil(x, selection = NULL, n = NULL, margin = c("documents",
  "features"), method = "correlation", upper = FALSE, diag = FALSE)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{selection}{character vector of document names or feature labels from
\code{x}.  A \code{"dist"} object is returned if selection is \code{NULL}, 
otherwise, a matrix is returned.}

\item{n}{the top \code{n} highest-ranking items will be returned.  If n is 
\code{NULL}, return all items.  Useful if the output object will be coerced
into a list, for instance if the top \code{n} most similar features to a
target feature is desired.  (See examples.)}

\item{margin}{identifies the margin of the dfm on which similarity or 
difference will be computed:  \code{documents} for documents or 
\code{features} for word/term features.}

\item{method}{method the similarity or distance measure to be used; see
Details}

\item{upper}{whether the upper triangle of the symmetric \eqn{V \times V} 
matrix is recorded}

\item{diag}{whether the diagonal of the distance matrix should be recorded}

\item{p}{The power of the Minkowski distance.}
}
\description{
These functions compute matrixes of distances and similarities between 
documents or features from a \code{\link{dfm}} and return a 
\code{\link[stats]{dist}} object (or a matrix if specific targets are
selected).
}
\details{
\code{textstat_dist} options are: \code{"euclidean"} (default), 
  \code{"Chisquared"}, \code{"Chisquared2"}, \code{"hamming"},
  \code{"kullback"}. \code{"manhattan"}, \code{"maximum"}, \code{"canberra"},
  and \code{"minkowski"}.

\code{textstat_simil} options are: \code{"correlation"} (default), 
  \code{"cosine"}, \code{"jaccard"}, \code{"eJaccard"}, \code{"dice"},
  \code{"eDice"}, \code{"simple matching"}, \code{"hamann"}, and 
  \code{"faith"}.
}
\note{
If you want to compute similarity on a "normalized" dfm object 
  (controlling for variable document lengths, for methods such as correlation
  for which different document lengths matter), then wrap the input dfm in 
  \code{\link{weight}(x, "relFreq")}.
}
\examples{
# create a dfm from inaugural addresses from Reagan onwards
presDfm <- dfm(corpus_subset(data_corpus_inaugural, Year > 1990), 
               remove = stopwords("english"), stem = TRUE, remove_punct = TRUE)
               
# distances for documents 
(d1 <- textstat_dist(presDfm, margin = "documents"))
as.matrix(d1)

# distances for specific documents
textstat_dist(presDfm, "2017-Trump", margin = "documents")
textstat_dist(presDfm, "2005-Bush", margin = "documents", method = "eJaccard")
(d2 <- textstat_dist(presDfm, c("2009-Obama" , "2013-Obama"), margin = "documents"))
as.list(d1)

# similarities for documents
(s1 <- textstat_simil(presDfm, method = "cosine", margin = "documents"))
as.matrix(s1)
as.list(s1)

# similarities for for specific documents
textstat_simil(presDfm, "2017-Trump", margin = "documents")
textstat_simil(presDfm, "2017-Trump", method = "cosine", margin = "documents")
textstat_simil(presDfm, c("2009-Obama" , "2013-Obama"), margin = "documents")

# compute some term similarities
(s2 <- textstat_simil(presDfm, c("fair", "health", "terror"), method = "cosine", 
                      margin = "features", n = 8))
as.list(s2)

}
\seealso{
\code{\link{textstat_dist}}, \code{\link{as.list.dist}},
  \code{\link{dist}}
}
\author{
Kenneth Benoit, Haiyan Wang
}
