% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-methods-quanteda.R
\name{docnames}
\alias{docnames}
\alias{docnames<-}
\title{get or set document names}
\usage{
docnames(x)

docnames(x) <- value
}
\arguments{
\item{x}{the object with docnames}

\item{value}{a character vector of the same length as \code{x}}
}
\value{
\code{docnames} returns a character vector of the document names

\code{docnames <-} assigns new values to the document names of a corpus. (Does not work
for dfm objects, whose document names are fixed.)
}
\description{
Get or set the document names of a \link{corpus}, \link{tokens}, or \link{dfm} object.
}
\examples{
# query the document names of a corpus
docnames(data_corpus_irishbudget2010)

# query the document names of a tokens object
docnames(tokens(data_char_ukimmig2010))

# query the document names of a dfm
docnames(dfm(data_char_inaugural[1:5]))

# reassign the document names of the inaugural speech corpus
docnames(data_corpus_inaugural) <- paste("Speech", 1:ndoc(data_corpus_inaugural), sep="")

}
\seealso{
\code{\link{featnames}}
}
\keyword{corpus}
\keyword{dfm}

