% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stopwords.R
\name{selectFeatures}
\alias{selectFeatures}
\alias{selectFeatures.dfm}
\title{select features from an object}
\usage{
selectFeatures(x, features, ...)

\method{selectFeatures}{dfm}(x, features = NULL, selection = c("keep",
  "remove"), valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{x}{object whose features will be selected}

\item{features}{character vector of \link{regex}{regular expressions}
definding the features to be selected, or a dictionary class object whose
values will provide the features to be selected.  If a dictionary class
object, the values will be interpreted as regular expressions.  (We may add
the option for other formats in the next revision.)}

\item{...}{supplementary arguments passed to the underlying functions in
\code{\link[stringi]{stri_detect_regex}}.  (This is how
\code{case_insensitive} is passed, but you may wish to pass others.)}

\item{selection}{whether to keep or remove the features}

\item{valuetype}{how to interpret feature vector: \code{fixed} for words as
is; \code{"regex"} for regular expressions; or \code{"glob"} for
"glob"-style wildcard}

\item{case_insensitive}{ignore the case of dictionary values if \code{TRUE}}

\item{verbose}{if \code{TRUE} print message about how many features were
removed}
}
\description{
This function selects or discards features from a dfm.variety of objects,
such as tokenized texts, a dfm, or a list of collocations.  The most common usage for
\code{removeFeatures} will be to eliminate stop words from a text or
text-based object, or to select only features from a list of regular
expression.
}
\note{
This function selects features based on their labels.  To select
  features based on the values of a the document-feature matrix, use
  \code{\link{trim}}.
}
\examples{
myDfm <- dfm(c("My Christmas was ruined by your opposition tax plan.",
               "Does the United_States or Sweden have more progressive taxation?"),
             toLower = FALSE, verbose = FALSE)
mydict <- dictionary(list(countries = c("United_States", "Sweden", "France"),
                          wordsEndingInY = c("by", "my"),
                          notintext = "blahblah"))
selectFeatures(myDfm, mydict)
selectFeatures(myDfm, mydict, case_insensitive = FALSE)
selectFeatures(myDfm, c("s$", ".y"), "keep", valuetype = "regex")
selectFeatures(myDfm, c("s$", ".y"), "remove", valuetype = "regex")
selectFeatures(myDfm, stopwords("english"), "keep", valuetype = "fixed")
selectFeatures(myDfm, stopwords("english"), "remove", valuetype = "fixed")
}
\seealso{
\code{\link{removeFeatures}}, \code{\link{trim}}
}

