% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/corpus.R, R/dfm-main.R
\name{docnames}
\alias{docnames}
\alias{docnames.corpus}
\alias{docnames.dfm}
\alias{docnames<-}
\title{get or set document names}
\usage{
docnames(x)

\method{docnames}{corpus}(x)

docnames(x) <- value

\method{docnames}{dfm}(x)
}
\arguments{
\item{x}{the object with docnames}

\item{value}{a character vector of the same length as \code{x}}
}
\value{
\code{docnames} returns a character vector of the document names

\code{docnames<-} assigns a character vector of the document names in a corpus
}
\description{
Extract the document names from a corpus or a document-feature matrix.  Document names are the
rownames of the documents data.frame in a corpus, or the rownames of the \link{dfm}
object for a dfm.
of the \link{dfm} object.

\code{docnames} queries the document names of a corpus or a dfm

\code{docnames <-} assigns new values to the document names of a corpus.  (Does not work
for dfm objects, whose document names are fixed.)
}
\examples{
# query the document names of the inaugural speech corpus
docnames(inaugCorpus) <- paste("Speech", 1:ndoc(inaugCorpus), sep="")

# reassign the document names of the inaugural speech corpus
docnames(inaugCorpus) <- paste("Speech", 1:ndoc(inaugCorpus), sep="")
# query the document names of a dfm
docnames(dfm(inaugTexts[1:5]))
}

