% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/corpus.R, R/dfm-main.R
\name{ndoc}
\alias{ndoc}
\alias{ndoc.corpus}
\alias{ndoc.dfm}
\alias{nfeature}
\alias{nfeature.corpus}
\alias{nfeature.dfm}
\title{get the number of documents or features}
\usage{
ndoc(x)

\method{ndoc}{corpus}(x)

\method{ndoc}{dfm}(x, ...)

nfeature(x)

\method{nfeature}{corpus}(x)

\method{nfeature}{dfm}(x)
}
\arguments{
\item{x}{a corpus or dfm object}

\item{...}{additional parameters}
}
\value{
an integer (count) of the number of documents or features in the corpus or dfm
}
\description{
Returns the number of documents or features in a quanteda object.
}
\examples{
ndoc(subset(inaugCorpus, Year>1980))
ndoc(dfm(subset(inaugCorpus, Year>1980), verbose=FALSE))
mydfm <- dfm(subset(inaugCorpus, Year>1980), verbose=FALSE)
nfeature(mydfm)
nfeature(trim(mydfm, minDoc=5, minCount=10))
}

