% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DateManipulation.R
\name{AddDate}
\alias{AddDate}
\title{AddDate}
\usage{
AddDate(date = Sys.Date(), addDays = 0, addMonths = 0, addYears = 0)
}
\arguments{
\item{date}{Initial date.}

\item{addDays}{If specified, vector number of days to add to the initial date.}

\item{addMonths}{If specified, vector number of months to add to the initial date.}

\item{addYears}{If specified, vector number of years to add to the initial date.}
}
\value{
The output is the final date after adding the number of days, months and years to the initial date.
}
\description{
Function to add a number of days, months and years to a specific date.
The length of addDays, addMonths and addYears must be the same.
}
\examples{
# Date input as Date object
AddDate(date = Sys.Date(),addDays=14,addMonths=2,addYears=3)

# Date input as character object
AddDate(date = '2019-10-04',addDays=14,addMonths=2,addYears=3)

}
\author{
Julian Chitiva and Diego Jara
}
