% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSOSS.r
\name{QUALYPSOSSlight}
\alias{QUALYPSOSSlight}
\title{QUALYPSOSSlight}
\usage{
QUALYPSOSSlight(ClimateProjections, scenAvail, predCont, predContUnique,
  iCpredCont, iCpredContUnique, listOption, lScen, RK, listCR)
}
\arguments{
\item{ClimateProjections}{matrix \code{nT} x \code{nS} of climate projections where \code{nT} is the number of values for the continuous predictor
(years, global temperature) and \code{nS} the number of scenarios.}

\item{scenAvail}{matrix of scenario characteristics \code{nS} x \code{nK} where \code{nK} is the number of discrete predictors.}

\item{predCont}{(optional) matrix \code{nT} x \code{nS} of continuous predictors.}

\item{predContUnique}{(optional) vector of length \code{nP} corresponding to the continuous predictor for which we want to obtain the prediction.}

\item{iCpredCont}{(optional) index in \code{1:nT} indicating the reference period (reference period) for the computation of change variables.}

\item{iCpredContUnique}{(optional) index in \code{1:nP} indicating the reference continuous predictor for the computation of change variables.}

\item{listOption}{(optional) list of options
\itemize{
  \item \strong{lambdaClimateResponse}: smoothing parameter > 0 for the extraction of the climate response.
  \item \strong{lambdaHyperParANOVA}: hyperparameter \eqn{b} for the \eqn{\lambda} parameter related to each predictor \eqn{g}.
  \item \strong{typeChangeVariable}: type of change variable: "abs" (absolute, value by default) or "rel" (relative).
  \item \strong{nBurn}: number of burn-in samples (default: 1000). If \code{nBurn} is too small, the convergence of MCMC chains might not be obtained.
  \item \strong{nKeep}: number of kept samples (default: 2000). If \code{nKeep} is too small, MCMC samples might not be represent correctly the posterior
  distributions of inferred parameters.
  \item \strong{nCluster}: number of clusters used for the computation of reproducing kernels (default: 1). 
  When \code{nCluster} is greater than one, parallelization is used to apply \code{QUALYPSOSS} over multiple time steps or 
  grid points simultaneously.
  \item \strong{quantileCompress}: vector of probabilities (in [0,1]) for which we compute the quantiles from the posterior distributions
   \code{quantileCompress = c(0.005,0.025,0.05,0.5,0.95,0.975,0.995)} by default.
   \code{uniqueFit}: logical, if \code{FALSE} (default), climate responses are fitted using Bayesian smoothing splines, otherwise,if \code{TRUE},
   a unique cubic smoothing spline is fitted for each run, using the function \link[stats]{smooth.spline}.
   \code{returnMCMC}: logical, if \code{FALSE} (default), the list \code{MCMC} is empty in the returned object.
}}

\item{lScen}{list of objects related to the scenario characteristics: item of the list obtained from \code{\link{QUALYPSOSS}}}

\item{RK}{Reproducing kernels: item of the list obtained from \code{\link{QUALYPSOSS}}}

\item{listCR}{Object for the extraction of the climate response: item of the list obtained from \code{\link{QUALYPSOSS}}}
}
\value{
list with the following fields:

\itemize{
  \item \strong{MEAN}: list containing the mean estimate of different quantities: \code{ResidualVariability} (residual variability),
  \code{InternalVariability} (internal variability), \code{lambda} (smoothing parameters), \code{grandMean} (grand mean for all time
  steps), \code{effect} (list with one item per discrete predictor \code{i}, containing matrices \code{nT} x \code{nEffi}, 
  where \code{nEffi} is the number of possible values for the discrete predictor \code{i}).
  \item \strong{QUANT}: list containing quantiles of different estimated quantities, listed in \strong{MEAN}.
  \item \strong{DECOMPVAR}: list with the contribution of all components to the total uncertainty, provided in \code{TotalVar} for 
  all time steps. In addition, for each discrete predictor, \code{ContribEffect} provides the relative contribution of possible
  discrete value (e.g. the contribution of one RCM to the uncertainty due to RCMs).
}
}
\description{
same as QUALYPSOSS, but less outputs are returned, and arguments are mandatory, in order to limit processing tasks which are repeated 
over a grid.
}
\author{
Guillaume Evin
}
