% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_colmap.R
\name{extract_colmap}
\alias{extract_colmap}
\title{Extract column map from survey data download}
\usage{
extract_colmap(respdata)
}
\arguments{
\item{respdata}{Response data including a column map dataframe as an attribute}
}
\description{
Helper function to extract the column map attached to a response data
download obtained from \code{\link[qualtRics]{fetch_survey}} (using the
default \code{add_column_map = TRUE})
}
\examples{
\dontrun{
# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve a single survey
mysurvey <- fetch_survey(surveyID = surveys$id[6])

# Extract column mapping for survey
extract_colmap(mysurvey)
}

}
