% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_quadtree}
\alias{read_quadtree}
\alias{write_quadtree}
\alias{read_quadtree,character-method}
\alias{write_quadtree,character-method}
\alias{write_quadtree,character,Quadtree-method}
\title{Read/write a \code{Quadtree}}
\usage{
\S4method{read_quadtree}{character}(x)

\S4method{write_quadtree}{character,Quadtree}(x, y)
}
\arguments{
\item{x}{character; the filepath to read from or write to}

\item{y}{a \code{\link{Quadtree}}}
}
\value{
\code{read_quadtree()} - returns a \code{\link{Quadtree}}

\code{write_quadtree()} - no return value
}
\description{
Reads and writes a \code{\link{Quadtree}}.
}
\details{
To read/write a quadtree object, the C++ library \code{cereal} is used to
serialize the quadtree and save it to a file. The file extension is
unimportant - it can be anything (I've been using the extension '.qtree').
}
\examples{
library(quadtree)
data(habitat)

qt <- quadtree(habitat, .1)

path <- tempfile(fileext = "qtree")
write_quadtree(path, qt)
qt2 <- read_quadtree(path)
}
