% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_neighbors.R
\name{get_neighbors}
\alias{get_neighbors}
\alias{get_neighbors,Quadtree,numeric-method}
\title{Get the neighbors of a \code{Quadtree} cell}
\usage{
\S4method{get_neighbors}{Quadtree,numeric}(x, y)
}
\arguments{
\item{x}{\code{\link{Quadtree}}}

\item{y}{two-element numeric vector; the x and y coordinates of a point -
this is used to identify which quadtree cell to find neighbors for.}
}
\value{
A six-column matrix with one row per neighboring cell. It has the following
columns: \itemize{
    \item \code{id}: the ID of the cell
    \item \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}: the x and y
    limits of the cell
    \item \code{value}: the value of the cell
  }

Note that this return matrix only includes terminal nodes/cells - that is,
cells that have no children. Also note that cells that are diagonal from each
other are considered to be neighbors.
}
\description{
Returns a matrix with information about the neighbors of a
quadtree cell.
}
\examples{
library(quadtree)
data(habitat)

# create a quadtree
qt <- quadtree(habitat, split_threshold = .1, adj_type = "expand")

# get the cell's neighbors
pt <- c(27000, 10000)
nbs <- get_neighbors(qt, pt)

# plot the neighbors
plot(qt, border_lwd = .3)
points(pt[1], pt[2], col = "black", bg = "lightblue", pch = 21)
with(data.frame(nbs),
   rect(xmin, ymin, xmax, ymax, col = "red", border = "black", lwd = 2))
}
