% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gene_query_func.R
\name{create_gene_query_func}
\alias{create_gene_query_func}
\title{Create a function to query genes}
\usage{
create_gene_query_func(
  dbfile = NULL,
  db = NULL,
  table_name = "genes",
  chr_field = "chr",
  start_field = "start",
  stop_field = "stop",
  filter = NULL
)
}
\arguments{
\item{dbfile}{Name of database file}

\item{db}{Optional database connection (provide one of \code{file} and \code{db}).}

\item{table_name}{Name of table in the database}

\item{chr_field}{Name of chromosome field}

\item{start_field}{Name of field with start position (in basepairs)}

\item{stop_field}{Name of field with stop position (in basepairs)}

\item{filter}{Additional SQL filter (as a character string).}
}
\value{
Function with three arguments, \code{chr}, \code{start},
and \code{end}, which returns a data frame with the genes
overlapping that region, with \code{start} and \code{end} being
in Mbp. The output should contain at least the columns
\code{Name}, \code{chr}, \code{start}, and \code{stop}, the
latter two being positions in Mbp.
}
\description{
Create a function that will connect to a SQLite database of gene
information and return a data frame with gene information for a
selected region.
}
\details{
Note that this function assumes that the database has
\code{start} and \code{stop} fields that are in basepairs, but
the selection uses positions in Mbp, and the output data frame
should have \code{start} and \code{stop} columns in Mbp.

Also note that a SQLite database of MGI mouse genes
is available at figshare:
\href{https://doi.org/10.6084/m9.figshare.5286019.v7}{doi:10.6084/m9.figshare.5286019.v7}
}
\examples{
# create query function by connecting to file
dbfile <- system.file("extdata", "mouse_genes_small.sqlite", package="qtl2")
query_genes <- create_gene_query_func(dbfile, filter="(source=='MGI')")
# query_genes will connect and disconnect each time
genes <- query_genes("2", 97.0, 98.0)

# connect and disconnect separately
library(RSQLite)
db <- dbConnect(SQLite(), dbfile)
query_genes <- create_gene_query_func(db=db, filter="(source=='MGI')")
genes <- query_genes("2", 97.0, 98.0)
dbDisconnect(db)
}
