% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2cross2.R
\name{convert2cross2}
\alias{convert2cross2}
\title{Convert R/qtl cross object to new format}
\usage{
convert2cross2(cross)
}
\arguments{
\item{cross}{An object of class \code{"cross"}; see
\code{\link[qtl:read.cross]{qtl::read.cross()}} for details.}
}
\value{
Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.
}
\description{
Convert a cross object from the R/qtl format to the R/qtl2 format
}
\examples{
library(qtl)
data(hyper)
hyper2 <- convert2cross2(hyper)
}
\seealso{
\code{\link[=read_cross2]{read_cross2()}}
}
\keyword{utilities}
