% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qread}
\alias{qread}
\title{qread}
\usage{
qread(file, use_alt_rep=TRUE, inspect=FALSE, nthreads=1)
}
\arguments{
\item{file}{the file name/path}

\item{use_alt_rep}{Use alt rep when reading in string data.  Default: TRUE}

\item{inspect}{Whether to call qinspect before de-serializing data.  Set to true if you suspect your data may be corrupted.  Default: FALSE}

\item{nthreads}{Number of threads to use.  Default 1.}
}
\value{
The de-serialized object
}
\description{
Reads a object in a file serialized to disk
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
x2 <- qread(myfile)
identical(x, x2) # returns true

# qs support multithreading
qsave(x, myfile, nthreads=2)
x2 <- qread(myfile, nthreads=2)
identical(x, x2) # returns true

# Other examples
z <- 1:1e7
myfile <- tempfile()
qsave(z, myfile)
z2 <- qread(myfile)
identical(z, z2) # returns true

w <- as.list(rnorm(1e6))
myfile <- tempfile()
qsave(w, myfile)
w2 <- qread(myfile)
identical(w, w2) # returns true
}
