% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpdf.R
\name{qpdf}
\alias{qpdf}
\alias{pdf_split}
\alias{pdf_length}
\alias{pdf_subset}
\alias{pdf_combine}
\alias{pdf_compress}
\alias{pdf_overlay_stamp}
\alias{pdf_rotate_pages}
\title{Split, Combine and Compress PDF Files}
\usage{
pdf_split(input, output = NULL, password = "")

pdf_length(input, password = "")

pdf_subset(input, pages = 1, output = NULL, password = "")

pdf_combine(input, output = NULL, password = "")

pdf_compress(input, output = NULL, linearize = FALSE, password = "")

pdf_overlay_stamp(input, stamp, output = NULL, password = "")

pdf_rotate_pages(
  input,
  pages,
  angle = 90,
  relative = FALSE,
  output = NULL,
  password = ""
)
}
\arguments{
\item{input}{path or url to the input pdf file}

\item{output}{base path of the output file(s)}

\item{password}{string with password to open pdf file}

\item{pages}{a vector with page numbers to rotate}

\item{linearize}{enable pdf linearization (streamable pdf)}

\item{stamp}{pdf file of which the first page is overlayed into each page of input}

\item{angle}{rotation angle in degrees (positive = clockwise)}

\item{relative}{if \code{TRUE}, pages are rotated relative to their current orientation. If \code{FALSE}, rotation is absolute (0 = portrait, 90 = landscape, rotated 90 degrees clockwise from portrait)}
}
\description{
Content-preserving transformations transformations of PDF files. Note qpdf does
not read actual content from PDF files: to extract text and data you need the
pdftools package.
}
\details{
Currently the package provides the following wrappers:
\itemize{
\item \link{pdf_length}: show the number of pages in a pdf
\item \link{pdf_split}: split a single pdf into separate files, one for each page
\item \link{pdf_subset}: create a new pdf with a subset of the input pages
\item \link{pdf_combine}: join several pdf files into one
\item \link{pdf_compress}: compress or linearize a pdf file
\item \link{pdf_rotate_pages}: rotate selected pages
}

These functions do not modify the \code{input} file: they create new output file(s)
and return the path(s) to these newly created files.
}
\examples{
\donttest{
# extract some pages
pdf_file <- file.path(tempdir(), "output.pdf")
pdf_subset('https://cran.r-project.org/doc/manuals/r-release/R-intro.pdf',
  pages = 1:3, output = pdf_file)
pdf_length(pdf_file)
unlink(pdf_file)
}
}
