% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{style_options}
\alias{style_options}
\alias{set_style_options}
\alias{reset_style_options}
\alias{get_style_options}
\alias{close_file}
\alias{set_variable_labels}
\alias{get_variable_labels}
\alias{set_stat_labels}
\alias{get_stat_labels}
\alias{reset_qol_options}
\title{Set Global Styling Options For Excel Workbooks}
\usage{
set_style_options(...)

reset_style_options()

get_style_options()

close_file()

set_variable_labels(...)

get_variable_labels()

set_stat_labels(...)

get_stat_labels()

reset_qol_options()
}
\arguments{
\item{...}{Put in any styling option from \code{\link[=excel_output_style]{excel_output_style()}} or \code{\link[=number_format_style]{number_format_style()}}
with the new value.}
}
\value{
\code{\link[=set_style_options]{set_style_options()}}: Returns modified global styling options.

\code{\link[=reset_style_options]{reset_style_options()}}: Returns default global styling options.

\code{\link[=get_style_options]{get_style_options()}}: List of global styling options.

\code{\link[=close_file]{close_file()}}: List of global styling options with file = NULL.

\code{\link[=set_variable_labels]{set_variable_labels()}}: List of variable labels.

\code{\link[=get_variable_labels]{get_variable_labels()}}: List of variable labels.

\code{\link[=set_stat_labels]{set_stat_labels()}}: List of statistic labels.

\code{\link[=get_stat_labels]{get_stat_labels()}}: List of statistic labels.

\code{\link[=reset_qol_options]{reset_qol_options()}}: Returns default global options.
}
\description{
Modify Styling options for Excel workbooks. Available parameters can be seen in
\code{\link[=excel_output_style]{excel_output_style()}} or \code{\link[=number_format_style]{number_format_style()}}.

\code{\link[=set_style_options]{set_style_options()}} sets the styling options for Excel workbooks globally.These
options are used by all tabulation and output functions, which are capable of
exporting styled outputs.

\code{\link[=reset_style_options]{reset_style_options()}} resets global style options to the default parameters.

\code{\link[=get_style_options]{get_style_options()}} prints out the currently set global styling options.

\code{\link[=close_file]{close_file()}} is a simple, more readable wrapper for setting file parameter to NULL.

\code{\link[=set_variable_labels]{set_variable_labels()}}: Can set variable labels globally so that they don't
have to be provided in every output function separately.

\code{\link[=get_variable_labels]{get_variable_labels()}}: Get the globally stored variable labels.

\code{\link[=set_stat_labels]{set_stat_labels()}}: Can set statistic labels globally so that they don't
have to be provided in every output function separately.

\code{\link[=get_stat_labels]{get_stat_labels()}}: Get the globally stored statistic labels.

\code{\link[=reset_qol_options]{reset_qol_options()}} resets global options to the default parameters.
}
\examples{
set_style_options(save_path    = "C:/My Projects/",
                  sum_decimals = 8)

reset_style_options()

get_style_options()

close_file()

set_variable_labels(age_gr = "Group of ages",
                    status = "Current status")

get_variable_labels()

set_stat_labels(pct  = "\%",
                freq = "Count")

get_stat_labels()

reset_qol_options()

}
\seealso{
Functions that use global styling optionss: \code{\link[=any_table]{any_table()}}, \code{\link[=frequencies]{frequencies()}},
\code{\link[=crosstabs]{crosstabs()}}.

Functions that also use global variable labels: \code{\link[=export_with_style]{export_with_style()}}.

Functions that use global variable and statistic labels: \code{\link[=any_table]{any_table()}}, \code{\link[=frequencies]{frequencies()}},
\code{\link[=crosstabs]{crosstabs()}}.

Functions that also use global variable labels: \code{\link[=export_with_style]{export_with_style()}}.
}
