% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa3.1.R
\name{sqr.fit}
\alias{sqr.fit}
\title{Spline Quantile Regression (SQR)}
\usage{
sqr.fit(y, X, tau, c0, d = 1, weighted = FALSE, mthreads = FALSE)
}
\arguments{
\item{y}{response vector}

\item{X}{design matrix (\code{nrow(X) = length(y)})}

\item{tau}{sequence of quantile levels in (0,1)}

\item{c0}{penalty parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{mthreads}{if \code{TRUE}, multithread BLAS is enabled when available (default = \code{FALSE}, required for parallel computing)}
}
\value{
A list with the following elements:
  \item{coefficients}{matrix of regression coefficients}
  \item{nit}{number of iterations}
}
\description{
This function computes spline quantile regression (SQR) solution from response vector and design matrix.
It uses the FORTRAN code \code{rqfnb.f} in the "quantreg" package with the kind permission of Dr. R. Koenker.
}
