% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa3.1.R
\name{qspec.sar}
\alias{qspec.sar}
\title{Spline Autoregression (SAR) Estimator of Quantile Spectrum}
\usage{
qspec.sar(
  y,
  y.qser = NULL,
  tau,
  d = 1,
  p = NULL,
  order.max = NULL,
  spar = NULL,
  method = c("GCV", "AIC", "BIC"),
  weighted = FALSE,
  freq = NULL,
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{y.qser}{matrix or array of pre-calculated QSER (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.qser} is supplied, \code{y} can be left unspecified}

\item{tau}{sequence of quantile levels in (0,1)}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{p}{order of SAR model (default = \code{NULL}: automatically selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}

\item{spar}{penalty parameter alla \code{smooth.spline} (default = \code{NULL}: automatically selected)}

\item{method}{criterion for penalty parameter selection: \code{"GCV"}, \code{"AIC"} (default), or \code{"BIC"}}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{freq}{sequence of frequencies in [0,1) (default = \code{NULL}: all Fourier frequencies)}

\item{n.cores}{number of cores for parallel computing of QDFT if \code{y.qser = NULL} (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing of QDFT (default = \code{NULL})}
}
\value{
a list with the following elements:
  \item{spec}{matrix or array of SAR quantile spectrum}
  \item{freq}{sequence of frequencies}
  \item{fit}{object of SAR model}
  \item{qser}{matrix or array of quantile series if \code{y.qser = NULL}}
}
\description{
This function computes spline autoregression (SAR) estimate of quantile spectrum.
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
# compute from time series
y.sar <- qspec.sar(cbind(y1,y2),tau=tau,p=1)
qfa.plot(ff[sel.f],tau,Re(y.sar$spec[1,1,sel.f,]))
# compute from quantile series
y.qser <- qser(cbind(y1,y2),tau)
y.sar <- qspec.sar(y.qser=y.qser,tau=tau,p=1)
qfa.plot(ff[sel.f],tau,Re(y.sar$spec[1,1,sel.f,]))
}
