% Generated by roxygen2 (4.0.2): do not edit by hand
\name{qprep}
\alias{qprep}
\title{Quick Preparation of Text}
\usage{
qprep(text.var, rm.dash = TRUE, bracket = "all", missing = NULL,
  names = FALSE, abbreviation = qdapDictionaries::abbreviations,
  replace = NULL, ignore.case = TRUE, num.paste = TRUE, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{rm.dash}{logical.  If \code{TRUE} dashes will be removed.}

\item{bracket}{The type of bracket (and encased text) to remove.  This is one
of the strings \code{"curly"}, \code{"square"}, \code{"round"},
\code{"angle"} and \code{"all"}.  These strings correspond to: \{, [, (, <
or all four types.  Also takes the argument \code{NULL} which turns off this
parsing technique.}

\item{missing}{Value to assign to empty cells.}

\item{names}{logical.  If \code{TRUE} the sentences are given as the names of
the counts.}

\item{abbreviation}{A two column key of abbreviations (column 1) and long
form replacements (column 2) or a vector of abbreviations.  Default is to use
qdap's abbreviations data set.  Also takes the argument \code{NULL} which
turns off this parsing technique.}

\item{replace}{A vector of long form replacements if a data frame is not
supplied to the abbreviation argument.}

\item{ignore.case}{logical.  If \code{TRUE} replaces without regard to
capitalization.}

\item{num.paste}{logical.  If \code{TURE} a the elements of larger numbers are
separated with spaces.  If \code{FALSE} the elements will be joined without
spaces.  Also takes the argument \code{NULL} which turns off this parsing
technique.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{replace_symbol}}.}
}
\description{
Wrapper for \code{\link[qdap]{bracketX}}, \code{\link[qdap]{replace_number}},
\code{\link[qdap]{replace_symbol}}, \code{\link[qdap]{replace_abbreviation}}
and \code{\link[qdap]{scrubber}} to quickly prepare text for analysis.  Care
should be taken with this function to ensure data is properly formatted and
complete.
}
\note{
Care should be taken with this function to ensure data is properly
formatted and complete.
}
\examples{
\dontrun{
x <- "I like 60 (laughter) #d-bot and $6 @ the store w/o 8p.m."
qprep(x)
}
}
\seealso{
\code{\link[qdap]{bracketX}},
\code{\link[qdap]{replace_abbreviation}},
\code{\link[qdap]{replace_number}},
\code{\link[qdap]{replace_symbol}}
}

