% Generated by roxygen2 (4.0.2): do not edit by hand
\name{df2tm_corpus}
\alias{df2tm_corpus}
\alias{dtm}
\alias{polarity_frame}
\alias{tdm}
\alias{tm2qdap}
\alias{tm_corpus2df}
\alias{tm_corpus2wfm}
\title{Deprecated qdap Functions}
\usage{
df2tm_corpus(text.var, grouping.var = NULL, demographic.vars, ...)

tm2qdap(x)

tm_corpus2wfm(tm.corpus, col1 = "docs", col2 = "text", ...)

tm_corpus2df(tm.corpus, col1 = "docs", col2 = "text", sent.split = TRUE,
  ...)

tdm(text.var, grouping.var = NULL, vowel.check = TRUE, ...)

dtm(text.var, grouping.var = NULL, vowel.check = TRUE, ...)

polarity_frame(positives, negatives, pos.weights = 1, neg.weights = -1)
}
\arguments{
\item{text.var}{The text variable or a \code{\link[qdap]{wfm}} object.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{demographic.vars}{Additional demographic information about the grouping
variables.  This is a data.frame, list of equal length vectors, or a single
vector corresponding to the grouping variable/text variable.  This
information will be mapped to the DMetaData in the \code{\link[tm]{Corpus}}.}

\item{x}{A \code{\link[tm]{TermDocumentMatrix}}/\code{\link[tm]{DocumentTermMatrix}}.}

\item{tm.corpus}{A \code{\link[tm]{Corpus}} object.}

\item{col1}{Name for column 1 (the vector elements).}

\item{col2}{Name for column 2 (the names of the vectors).}

\item{sent.split}{logical.  If \code{TRUE} the text variable sentences will
be split into individual rows.}

\item{vowel.check}{logical.  Should terms without vowels be remove?}

\item{positives}{A character vector of positive words.}

\item{negatives}{A character vector of negative words.}

\item{pos.weights}{A vector of weights to weight each positive word by.
Length must be equal to length of \code{postives} or length 1 (if 1 weight
will be recycled).}

\item{neg.weights}{A vector of weights to weight each negative word by.
Length must be equal to length of \code{negatives} or length 1 (if 1 weight
will be recycled).}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{sentSplit}}.}
}
\description{
\code{df2tm_corpus} - Convert a qdap dataframe to a tm package
\code{\link[tm]{Corpus}}.

\code{tm2qdap} - Convert the \pkg{tm} package's
\code{\link[tm]{TermDocumentMatrix}}/\code{\link[tm]{DocumentTermMatrix}} to
\code{\link[qdap]{wfm}}.

\code{tm_corpus2wfm} - Convert a \code{\link[tm]{Corpus}} package corpus to a
\code{\link[qdap]{wfm}}.

\code{tm_corpus2df} - Convert a tm package corpus to a dataframe.

\code{tdm} - Create term document matrices from raw text or
\code{\link[qdap]{wfm}} for use with other text analysis packages.

\code{dtm} - Create document term matrices from raw text or
\code{\link[qdap]{wfm}} for use with other text analysis packages.

\code{polarity_frame} - Generate a polarity lookup hash key
for use with the \code{polarity.frame} argument in the \code{polarity}
function.
}
\section{Warning}{
 \code{df2tm_corpus} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.Corpus} instead.
}

\section{Warning}{
 \code{tm2qdap} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.wfm} instead.
}

\section{Warning}{
 \code{tm_corpus2wfm} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.wfm} instead.
}

\section{Warning}{
 \code{tm_corpus2df} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.data.frame} instead.
}

\section{Warning}{
 \code{tdm} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.tdm} instead.
}

\section{Warning}{
 \code{dtm} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{as.dtm} instead.
}

\section{Warning}{
 \code{polarity_frame} - function is deprecated.  It will be
removed in a subsequent version of qdap.  Use \code{sentiment_frame} instead.
}

