\name{qcc-package}
\alias{qcc-package}
\docType{package}
\title{Quality Control Charts}
\description{
Shewhart quality control charts for continuous, attribute and
count data. Cusum and EWMA charts. Operating characteristic
curves.  Process capability analysis. Pareto chart and
cause-and-effect chart. Multivariate control charts.
}
\details{
\tabular{ll}{
Package: \tab qcc\cr
Version: \tab 2.0\cr
Date: \tab 2009/10/15\cr
Depends: \tab R (>= 2.9)\cr
License: \tab GPL version 2 (or newer)
}

Index:
\preformatted{
boiler                  Bolier temperature data
cause.and.effect        Cause and effect diagram
circuit                 Circuit boards data
cusum                   Cusum chart
dyedcloth               Dyed cloth data
ellipseChart            Multivariate Quality Control Charts
ewma                    EWMA chart
ewmaSmooth              EWMA smoothing function
mqcc                    Multivariate Quality Control Charts
oc.curves               Operating Characteristic Function
orangejuice             Orange juice data
orangejuice2            Orange juice data -- Part 2
pareto.chart            Pareto chart
pcmanufact              Personal computer manufacturer data
pistonrings             Piston rings data
process.capability      Process capability analysis
qcc                     Quality Control Charts
qcc.groups              Grouping data based on a sample indicator
qcc.options             Set or return options for the 'qcc' package.
qcc.overdispersion.test
                        Overdispersion test for binomial and poisson
                        data
shewhart.rules          Functions specifying rules for Shewhart charts
stats.c                 Functions to plot Shewhart c chart
stats.g                 Statistics used in computing and drawing a
                        Shewhart g chart
stats.np                Statistics used in computing and drawing a
                        Shewhart np chart
stats.p                 Statistics used in computing and drawing a
                        Shewhart p chart
stats.R                 Statistics used in computing and drawing a
                        Shewhart R chart
stats.S                 Functions to plot Shewhart S chart
stats.T2                Statistics used in computing and drawing the
                        Hotelling T^2 chart for subgrouped data
stats.T2.single         Statistics used in computing and drawing the
                        Hotelling T^2 chart for individual observations
                        data
stats.u                 Statistics used in computing and drawing a
                        Shewhart u chart
stats.xbar              Statistics used in computing and drawing a
                        Shewhart xbar chart
stats.xbar.one          Statistics used in computing and drawing a
                        Shewhart xbar chart for one-at-time data
}
}
\author{Luca Scrucca \email{luca@stat.unipg.it}}
\references{
Mason, R.L. and Young, J.C. (2002) \emph{Multivariate Statistical Process Control with Industrial Applications}, SIAM. \cr
Montgomery, D.C. (2005) \emph{Introduction to Statistical Quality Control}, 5th ed. New York: John Wiley & Sons. \cr
Ryan, T. P. (2000), \emph{Statistical Methods for Quality Improvement}, 2nd ed. New York: John Wiley & Sons, Inc. \cr
Wetherill, G.B. and Brown, D.W. (1991) \emph{Statistical Process Control}. New York: Chapman & Hall.
}
\keyword{ package }
