% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.qad}
\alias{plot.qad}
\title{Plot conditional probabilites}
\usage{
\method{plot}{qad}(
  x,
  addSample = FALSE,
  copula = FALSE,
  density = FALSE,
  margins = FALSE,
  title = "",
  x.axis = "X1",
  y.axis = "X2",
  point.size = 0.9,
  panel.grid = TRUE,
  color = "plasma",
  rb_values = c(10, 0.315, 0.15),
  ...
)
}
\arguments{
\item{x}{an object of class qad.}

\item{addSample}{a logical indicating whether the observations are returned. In the copula setting the mass squares of the empirical copula are added too. (default = FALSE).}

\item{copula}{a logical indicating whether the plot depicts the conditional probabilities
of the empirical checkerboard copula or of the retransformed data setting (default = FALSE).}

\item{density}{a logical indicating whether the density should be plotted instead of the conditional probabilites (default = FALSE).
Only works in the copula setting, i.e. if copula = TRUE.}

\item{margins}{a logical indicating whether the margin distribution is added in form of a rug plot.}

\item{title}{The text for the title}

\item{x.axis}{The text for the x-axis}

\item{y.axis}{The text for the y-axis}

\item{point.size}{a numeric specifying the point size of the sample (relevant if addSample = TRUE).}

\item{panel.grid}{a logical indicating whether the panel grid is plotted. (default = TRUE)}

\item{color}{a color palette of the viridis package or rainbow. options are c("viridis", "magma", "inferno", "plasma", "cividis", "rainbow")}

\item{rb_values}{a vector of size 3 with number of values, start value and end value in the rainbow colors space.}

\item{...}{some methods for this generic require additional arguments.  None are used in this method.}
}
\description{
Visualizes the conditional probabilities for each strip of the checkerboard copula in the copula setting or in the retransformed sample setting.
}
\note{
The conditional probabilities are constant at squares in the copula setting. If the squares are retransformed in the data setting, the resulting objects are rectangles.
}
\examples{
## Example 1
n <- 100
x <- runif(n, 0, 1)
y <- runif(n, 0, 1)
sample <- data.frame(x, y)

#qad
fit <- qad(sample)
plot(fit, addSample = TRUE, copula = FALSE)

## Example 2
n <- 100
x <- runif(n, -1, 1)
y <- x^2 + rnorm(n, 0, 0.1)
sample <- data.frame(x, y)

#qad
fit <- qad(sample)
plot(fit, addSample = TRUE, copula = TRUE)
plot(fit, addSample = TRUE, copula = FALSE)

}
