% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{pairwise.qad}
\alias{pairwise.qad}
\title{Pairwise quantification of (asymmetric and directed) dependencies}
\usage{
pairwise.qad(
  data_df,
  remove.00 = FALSE,
  min.res = 3,
  p.value = TRUE,
  nperm = 1000,
  p.value_asymmetry = FALSE,
  nboot = 1000
)
}
\arguments{
\item{data_df}{a data frame containing numeric columns with the observations of the sample.}

\item{remove.00}{a logical indicating whether double 0 entries should be excluded (default = FALSE)}

\item{min.res}{an integer indicating the necessary minimum resolution of the checkerboard grid to compute qad, otherwise the result is NA (default = 3).}

\item{p.value}{a logical indicating whether to return a p-value of rejecting independence (based on permutation).}

\item{nperm}{an integer indicating the number of permutation runs.}

\item{p.value_asymmetry}{a logical indicating whether a p-value (based on bootstrap) is computed for the measure of asymmetry.}

\item{nboot}{an integer indicating the number of bootstrapping runs.}
}
\value{
a list, containing 8 data.frames with the dependence measures, corresponding p.values, the resolution of the checkerboard aggregation and the number of removed double zero entries (only if remove.00 = TRUE).
The output of pairwise.qad() can be illustrated using the function \code{heatmap.qad()}.
}
\description{
Pairwise computation of the function \code{qad}(). \code{qad}() is applied on each pair of variables of a numeric data.frame.
}
\examples{
n <- 100
x1 <- runif(n, 0, 1)
x2 <- x1^2 + rnorm(n, 0, 0.1)
x3 <- runif(n, 0, 1)
x4 <- x3 - x2 + rnorm(n, 0, 0.1)
sample_df <- data.frame(x1,x2,x3,x4)
#Fit qad
model <- pairwise.qad(sample_df, p.value = FALSE)
heatmap.qad(model, select = "dependence", fontsize = 6)
}
