/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.extend.AttributeValueAnnotation;
import eu.kliegr.ac1.rule.extend.Distribution;
import eu.kliegr.ac1.rule.extend.DistributionFactory;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.ExtendRuleAnnotation;
import eu.kliegr.ac1.rule.extend.RuleMultiItemAnnotation;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestRuleAnnotation
extends ExtendRuleAnnotation {
    private static final Logger LOGGER = Logger.getLogger(TestRuleAnnotation.class.getName());
    private final HashMap<AttributeValue, AttributeValueAnnotation> attributeValAnns = new HashMap();

    public void addAnnotation(RuleMultiItem rmi, RuleMultiItemAnnotation annot) {
        if (annot == null) {
            return;
        }
        annot.getAnnotations().forEach(ann -> this.attributeValAnns.put(ann.getValue(), (AttributeValueAnnotation)ann));
    }

    @Override
    public void generate(ExtendRule r, ArrayList<Consequent> consequents) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public RuleMultiItemAnnotation getAnnotation(RuleMultiItem rmi) {
        RuleMultiItemAnnotation annot = new RuleMultiItemAnnotation();
        rmi.getAttributeValues().forEach(val -> annot.add(this.attributeValAnns.get(val)));
        return annot;
    }

    @Override
    public String toString() {
        return this.attributeValAnns.values().stream().map(val -> val.toString()).reduce((val1, val2) -> val1 + "\n" + val2).orElse("");
    }

    public ValueOrigin getValueOrigin(AttributeValue tVal) {
        AttributeValueAnnotation val = this.attributeValAnns.get(tVal);
        if (val == null) {
            return null;
        }
        return val.getOrigin();
    }

    public Distribution getDistributionForValue(AttributeValue tVal, DistributionFactory distrFactory) {
        Distribution dist;
        AttributeValueAnnotation val = this.attributeValAnns.get(tVal);
        if (val != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Annotated value ''{0}'' found, exact match", tVal.toString(true, true));
            }
            dist = distrFactory.convert(val);
        } else {
            if (tVal.getAttribute().getType() != AttributeType.numerical) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Annotated value not found for ''{0}'', interpolation not possible for nominal attribute", tVal.toString(true, true));
                }
                return null;
            }
            AttributeValue higher = tVal.getAttribute().getAdjacentHigher(tVal, true);
            AttributeValue lower = tVal.getAttribute().getAdjacentLower(tVal, true);
            if (higher == null && lower == null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "No annotated adjacent values found for ''{0}''", tVal.toString(true, true));
                }
                return null;
            }
            if (higher == null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Only lower value found for ''{0}'', using this.", tVal.toString(true, true));
                }
                val = this.attributeValAnns.get(lower);
                dist = distrFactory.convert(val);
            } else if (lower == null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Only higher value found for ''{0}'', using this.", tVal.toString(true, true));
                }
                val = this.attributeValAnns.get(higher);
                dist = distrFactory.convert(val);
            } else {
                float[] weights = new float[2];
                weights[1] = (tVal.getNumericalValue().floatValue() - lower.getNumericalValue().floatValue()) / (higher.getNumericalValue().floatValue() - lower.getNumericalValue().floatValue());
                weights[0] = 1.0f - weights[1];
                ArrayList<Distribution> toAgg = new ArrayList<Distribution>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Performing interpolation for ''{0}'' between {1} with weight {2}(lower) and {3} with weight {4} (higher)", new Object[]{tVal.toString(true, true), lower.toString(true, true), Float.valueOf(weights[0]), higher.toString(true, true), Float.valueOf(weights[1])});
                }
                Distribution lowerD = distrFactory.convert(this.attributeValAnns.get(lower));
                lowerD.setWeight(Float.valueOf(weights[0]));
                toAgg.add(lowerD);
                Distribution higherD = distrFactory.convert(this.attributeValAnns.get(higher));
                higherD.setWeight(Float.valueOf(weights[1]));
                toAgg.add(higherD);
                dist = distrFactory.aggregate(toAgg);
            }
        }
        return dist;
    }
}

