% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetReviewResultsForHIT.R
\name{GetReviewResultsForHIT}
\alias{GetReviewResultsForHIT}
\alias{reviewresults}
\alias{ListReviewPolicyResultsForHIT}
\title{Get ReviewPolicy Results for a HIT}
\usage{
GetReviewResultsForHIT(hit, policy.level = NULL,
  results = as.integer(100), pagetoken = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{hit}{A character string containing a HITId.}

\item{policy.level}{Either \code{HIT} or \code{Assignment}. If \code{NULL}
(the default), all data for both policy levels is retrieved.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A four-element list containing up to four named data frames,
depending on what ReviewPolicy (or ReviewPolicies) were attached to the HIT
and whether results or actions are requested: \code{AssignmentReviewResult},
\code{AssignmentReviewAction}, \code{HITReviewResult}, and/or
\code{HITReviewAction}.
}
\description{
Get HIT- and/or Assignment-level ReviewPolicy Results for a HIT
}
\details{
A simple function to return the results of a ReviewPolicy. This is intended
only for advanced users, who should reference MTurk documentation for
further information or see the notes in
\code{\link{GenerateHITReviewPolicy}}.

\code{reviewresults} and \code{ListReviewPolicyResultsForHIT} are aliases.
}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html}{API Reference}

\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ReviewPoliciesArticle.html}{API Reference (ReviewPolicies)}

\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_HITReviewPolicyDataStructureArticle.html}{API Reference (Data Structure)}
}
\seealso{
\code{\link{CreateHIT}}

\code{\link{GenerateHITReviewPolicy}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{HITs}
