% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SendTestEventNotification.R
\name{SendTestEventNotification}
\alias{SendTestEventNotification}
\alias{notificationtest}
\title{Test a Notification}
\usage{
SendTestEventNotification(
  notification,
  test.event.type,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{notification}{A dictionary object Notification structure (e.g., returned by \code{\link{GenerateNotification}}).}

\item{test.event.type}{A character string containing one of:
\code{AssignmentAccepted}, \code{AssignmentAbandoned}, \code{AssignmentReturned},
\code{AssignmentSubmitted}, \code{AssignmentRejected}, \code{AssignmentApproved},
\code{HITCreated}, \code{HITExtended}, \code{HITDisposed}, \code{HITReviewable},
\code{HITCreated}, \code{HITExtended}, \code{HITDisposed}, \code{HITReviewable},
\code{HITExpired} (the default), or \code{Ping}.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the notification, the event type, and
details on whether the request was valid. As a side effect, a notification
will be sent to the configured destination (either an email or an SQS
queue).
}
\description{
Test a HITType Notification, for example, to try out a HITType Notification
before creating a HIT.
}
\details{
Test a Notification configuration. The test mimics whatever the Notification
configuration will do when the event described in \code{test.event.type}
occurs. For example, if a Notification has been configured to send an email
any time an Assignment is Submitted, testing for an AssignmentSubmitted
event should trigger an email. Similarly, testing for an AssignmentReturned
event should do nothing.

\code{notificationtest} is an alias.
}
\examples{

\dontrun{
hittype <- RegisterHITType(title="10 Question Survey",
                           description = "Complete a 10-question survey",
                           reward = ".20",
                           duration = seconds(hours = 1),
                           keywords = "survey, questionnaire, politics")

a <- GenerateNotification("requester@example.com", event.type = "HITExpired")

SetHITTypeNotification(hit.type = hittype$HITTypeId,
                       notification = a,
                       active = TRUE)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html}{API Reference}
}
\seealso{
\code{\link{SetHITTypeNotification}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Notifications}
