% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchQualificationTypes.R
\name{SearchQualificationTypes}
\alias{SearchQualificationTypes}
\alias{SearchQualifications}
\alias{SearchQuals}
\alias{searchquals}
\alias{ListQualificationTypes}
\alias{listquals}
\alias{ListQuals}
\title{Search Qualification Types}
\usage{
SearchQualificationTypes(
  search.query = NULL,
  must.be.requestable = FALSE,
  must.be.owner = FALSE,
  results = as.integer(100),
  return.pages = NULL,
  pagetoken = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{search.query}{An optional character string to use as a search query}

\item{must.be.requestable}{A boolean indicating whether the Qualification
must be requestable by Workers or not.}

\item{must.be.owner}{A boolean indicating whether to search only the
Qualifications you own / created, or to search all Qualifications.
Defaults to FALSE.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{return.pages}{An integer indicating how many pages of results should
be returned.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame of Qualification Types
}
\description{
Search for Qualification Types.
}
\details{
This function will search Qualification Types. It can search through the
Qualifications you created, or through all the Qualifications that exist.

\code{SearchQuals()}, \code{searchquals()},\code{ListQualificationTypes()}
\code{listquals()}, \code{ListQuals()} are aliases
}
\examples{

\dontrun{
SearchQuals()
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html}{API Reference}
}
\author{
Tyler Burleigh
}
\keyword{HITs}
