% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_level_disprop_analysis.R
\name{ror}
\alias{ror}
\title{Reporting Odds Ratio}
\usage{
ror(a = NULL, b = NULL, c = NULL, d = NULL, conf_lvl = 0.95)
}
\arguments{
\item{a}{Number of reports for the specific drug and event (i.e. the
observed count).}

\item{b}{Number of reports with the drug, without the event}

\item{c}{Number of reports without the drug, with the event}

\item{d}{Number of reports without the drug, without the event}

\item{conf_lvl}{Confidence level of confidence or credibility intervals.
Default is 0.95 (i.e. 95 \% confidence interval).}
}
\value{
A tibble with three columns (point estimate and credibility bounds).
Number of rows equals length of inputs a, b, c, d.
}
\description{
Calculates Reporting Odds Ratio ("ROR") and confidence
intervals, used in disproportionality analysis.
}
\details{
The ROR is an odds ratio calculated from reporting counts. The
R for Reporting in ROR is meant to emphasize an interpretation of reporting,
as the ROR is calculated from a reporting database. Note: the function is
vectorized, i.e. a, b, c and d can be vectors, see the examples.

A reporting odds ratio is simply an odds ratio based on adverse event
reports.
\deqn{\hat{ROR} = \frac{a/b}{c/d}}

where \eqn{a} = observed count (i.e. number of reports with exposure and
outcome), \eqn{b} = number of reports with the drug and without the event,
\eqn{c} = number of reports without the drug with the event and \eqn{d} =
number of reports with neither of the drug and the event.

A confidence interval for the ROR can be derived through the delta method,
with a standard deviation:

\deqn{\hat{s} = \sqrt{1/a + 1/b + 1/c + 1/d}}

with the resulting confidence interval for significance level \eqn{\alpha}

\deqn{[\hat{ROR} \times exp(\Phi_{\alpha/2} \times \hat{s}), \hat{ROR} \times exp(\Phi_{1-\alpha/2} \times \hat{s})]}
}
\examples{

ror(
  a = 5,
  b = 10,
  c = 20,
  d = 10000
)

# Note that a, b, c and d can be vectors (of equal length, no recycling)
pvda::ror(
  a = c(5, 10),
  b = c(10, 20),
  c = c(15, 30),
  d = c(10000, 10000)
)
}
\references{
\insertRef{Montastruc_2011}{pvda}
}
