% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid_thr.R
\name{pid.chol}
\alias{pid.chol}
\title{Recursive identification of panel SVAR models via Cholesky decomposition}
\usage{
pid.chol(x, order_k = NULL)
}
\arguments{
\item{x}{An object of class '\code{pvarx}' or a list of VAR objects 
that will be \link[=as.varx]{coerced} to '\code{varx}'. 
Estimated panel of VAR objects.}

\item{order_k}{Vector. Vector of characters or integers specifying the assumed structure of the recursive causality. 
Change the causal ordering in the instantaneous effects without permuting variables and re-estimating the VAR model.}
}
\value{
List of class '\code{pid}' with elements:
\item{A}{Matrix. The lined-up coefficient matrices \eqn{A_j, j=1,\ldots,p} 
   for the lagged variables in the panel VAR.}
\item{B}{Matrix. Mean group of the estimated structural impact matrices \eqn{B_i}, 
   i.e. the unique decomposition of the covariance matrices of reduced-form errors.}
\item{L.varx}{List of '\code{varx}' objects for the individual estimation results
  to which the structural impact matrices \eqn{B_i} have been added.}
\item{args_pid}{List of characters and integers indicating the identification methods and specifications that have been used.}
\item{args_pvarx}{List of characters and integers indicating the estimator and specifications that have been used.}
}
\description{
Given an estimated panel of VAR models, this function uses the Cholesky decomposition to identify  
  the structural impact matrix \eqn{B_i} of the corresponding SVAR model
  \deqn{y_{it} = c_{it} + A_{i1} y_{i,t-1} + ... + A_{i,p_i} y_{i,t-p_i} + u_{it}}
  \deqn{       = c_{it} + A_{i1} y_{i,t-1} + ... + A_{i,p_i} y_{i,t-p_i} + B_i \epsilon_{it}.}
  Matrix \eqn{B_i} corresponds to the decomposition of the least squares covariance matrix \eqn{\Sigma_{u,i} = B_i B_i'}.
}
\examples{
data("PCAP")
names_k = c("g", "k", "l", "y")  # variable names
names_i = levels(PCAP$id_i)      # country names
L.data  = sapply(names_i, FUN=function(i) 
  ts(PCAP[PCAP$id_i==i, names_k], start=1960, end=2019, frequency=1), 
  simplify=FALSE)

# estimate and identify panel SVAR #
L.vars = lapply(L.data, FUN=function(x) vars::VAR(x, p=2, type="both"))
R.pid  = pid.chol(L.vars, order_k=names_k)

}
\references{
Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Sims, C. A. (2008): 
  "Macroeconomics and Reality", 
  \emph{Econometrica}, 48, pp. 1-48.
}
\seealso{
Other panel identification functions: 
\code{\link{pid.cvm}()},
\code{\link{pid.dc}()},
\code{\link{pid.grt}()},
\code{\link{pid.iv}()}
}
\concept{panel identification functions}
