% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svarfevd.R
\name{fevd.id}
\alias{fevd.id}
\title{Forecast Error Variance Decomposition}
\usage{
\method{fevd}{id}(x, n.ahead = 10, ...)
}
\arguments{
\item{x}{SVAR object of class '\code{id}' or any other 
that will be \link[=as.varx]{coerced} to ('\code{id}', '\code{varx}').}

\item{n.ahead}{Integer specifying the steps ahead, i.e. the horizon of the FEVD.}

\item{...}{Currently not used.}
}
\value{
A list of class '\code{svarfevd}' holding the forecast error variance decomposition 
  of each variables as a '\code{data.frame}'.
}
\description{
Calculates the forecast error variance decomposition. Respects SVAR 
  models of cases \eqn{S \neq K}, i.e. partially identified or excess shocks, too.
}
\examples{
data("PCIT")
names_k = c("APITR", "ACITR", "PITB", "CITB", "GOV", "RGDP", "DEBT")
names_l = c("m_PI", "m_CI")  # proxy names
names_s = paste0("epsilon[ ", c("PI", "CI"), " ]")  # shock names
dim_p   = 4  # lag-order

# estimate and identify proxy SVAR #
R.vars = vars::VAR(PCIT[ , names_k], p=dim_p, type="const")
R.idBL = id.iv(R.vars, iv=PCIT[-(1:dim_p), names_l], S2="MR", cov_u="OMEGA")
colnames(R.idBL$B) = names_s  # labeling

# calculate and plot FEVD under partial identification #
plot(fevd(R.idBL, n.ahead=20))

}
\references{
Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Jentsch, Lunsford (2022): 
  "Asymptotically Valid Bootstrap Inference for Proxy SVARs", 
  \emph{Journal of Business and Economic Statistics}, 40, pp. 1876-1891.
}
