% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ChangePoints}
\alias{ChangePoints}
\title{Change Points of a \code{numeric} vector}
\usage{
ChangePoints(x)
}
\arguments{
\item{x}{\code{numeric} vector.}
}
\value{
The vector of index of change points.
}
\description{
Finds changes points (i.e. corners) in the \code{numeric} vector.
}
\details{
The end points of the vector will be always included in the results.
}
\examples{
x <- rwiener(100)
cid <- ChangePoints(x)
plot(x, type="l")
points(time(x)[cid], x[cid], cex=0.5, col=2, pch=19)
}
