% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-flatten.R
\name{list_flatten}
\alias{list_flatten}
\title{Flatten a list}
\usage{
list_flatten(
  x,
  ...,
  is_node = NULL,
  name_spec = "{outer}_{inner}",
  name_repair = c("minimal", "unique", "check_unique", "universal")
)
}
\arguments{
\item{x}{A list.}

\item{...}{These dots are for future extensions and must be empty.}

\item{is_node}{A predicate function that determines whether an element is
a node (by returning \code{TRUE}) or a leaf (by returning \code{FALSE}). The
default value, \code{NULL}, treats simple lists as nodes and everything else
(including richer objects like data frames and linear models) as leaves,
using \code{\link[vctrs:obj_is_list]{vctrs::obj_is_list()}}. To recurse into all objects built on lists
use \code{\link[=is.list]{is.list()}}.}

\item{name_spec}{If both inner and outer names are present, control
how they are combined. Should be a glue specification that uses
variables \code{inner} and \code{outer}.}

\item{name_repair}{One of \code{"minimal"}, \code{"unique"}, \code{"universal"}, or
\code{"check_unique"}. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for the meaning of these
options.}
}
\value{
A list of the same type as \code{x}. The list might be shorter
if \code{x} contains empty lists, the same length if it contains lists
of length 1 or no sub-lists, or longer if it contains lists of
length > 1.
}
\description{
Flattening a list removes a single layer of internal hierarchy,
i.e. it inlines elements that are lists leaving non-lists alone.
}
\examples{
x <- list(1, list(2, 3), list(4, list(5)))
x |> list_flatten() |> str()
x |> list_flatten() |> list_flatten() |> str()

# Flat lists are left as is
list(1, 2, 3, 4, 5) |> list_flatten() |> str()

# Empty lists will disappear
list(1, list(), 2, list(3)) |> list_flatten() |> str()

# Another way to see this is that it reduces the depth of the list
x <- list(
  list(),
  list(list())
)
x |> pluck_depth()
x |> list_flatten() |> pluck_depth()

# Use name_spec to control how inner and outer names are combined
x <- list(x = list(a = 1, b = 2), y = list(c = 1, d = 2))
x |> list_flatten() |> names()
x |> list_flatten(name_spec = "{outer}") |> names()
x |> list_flatten(name_spec = "{inner}") |> names()

# Set `is_node = is.list` to also flatten richer objects built on lists like
# data frames and linear models
df <- data.frame(x = 1:3, y = 4:6)
x <- list(
  a_string = "something",
  a_list = list(1:3, "else"),
  a_df = df
)
x |> list_flatten(is_node = is.list)

# Note that objects that are already "flat" retain their classes
list_flatten(df, is_node = is.list)
}
