% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce}
\alias{reduce}
\alias{reduce_right}
\title{Reduce a list to a single value by iteratively applying a binary function.}
\usage{
reduce(.x, .f, ..., .init)

reduce_right(.x, .f, ..., .init)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A two-argument function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.init}{If supplied, will be used as the first value to start
the accumulation, rather than using \code{x[[1]]}. This is useful if
you want to ensure that \code{reduce} returns the correct value when
\code{.x} is \code{\link{is_empty}()}.}
}
\description{
\code{reduce} combines from the left, \code{reduce_right} combines from
the right.
}
\examples{
1:3 \%>\% reduce(`+`)
1:10 \%>\% reduce(`*`)

5 \%>\%
  replicate(sample(10, 5), simplify = FALSE) \%>\%
  reduce(intersect)

x <- list(c(0, 1), c(2, 3), c(4, 5))
x \%>\% reduce(c)
x \%>\% reduce_right(c)
# Equivalent to:
x \%>\% rev() \%>\% reduce(c)

# Use init when you want reduce to return a consistent type when
# given an empty lists
list() \%>\% reduce(`+`)
list() \%>\% reduce(`+`, .init = 0)
}
